/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Triple;

/**
 * @author Tuukka Lehtonen
 */
public class DoubleToIntegerPropertyFactory extends ReadFactoryImpl<Resource, Integer> {

    final private String propertyURI;

    public DoubleToIntegerPropertyFactory(String propertyURI) {
        this.propertyURI = propertyURI;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Triple<Resource, String, Object>((Resource) inputContents, propertyURI, getClass());
    }

    @Override
    public Integer perform(ReadGraph graph, Resource r) throws DatabaseException {
        Double value = graph.getPossibleRelatedAdapter(r, graph.getResource(propertyURI), Double.class);
        return value == null ? 0 : value.intValue();
    }

}
