/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions.e4;

import java.util.Arrays;
import java.util.List;

import javax.inject.Named;

import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.actions.style.EditStyle;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * Style Edit
 * 
 * TODO : should we have extension point for expanding styles?
 * TODO : default ColorChooser is not suitable for this task
 * TODO : how to store MetricsFormat template list
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class EditStyleHandler {

    private Resource[] lastResources = Resource.NONE;
    private boolean cachedCanExecute;

    @CanExecute
    public boolean canExecute(@Named(IServiceConstants.ACTIVE_SELECTION) ISelection s, @Active MPart part) throws DatabaseException, InterruptedException {
        if (!(part.getObject() instanceof CompatibilityEditor))
            return false;
        CompatibilityEditor editor = (CompatibilityEditor) part.getObject();
        if (!(editor.getPart() instanceof DiagramEditor))
            return false;
        if (s == null)
            return false;
        if (DatabaseJob.inProgress())
            return false;
        final Resource[] resources = ResourceAdaptionUtils.toResources(s);
        if (resources.length != 0) {
            if (!Arrays.equals(resources, lastResources)) {
                lastResources = resources;
                cachedCanExecute = areStyleProviders(resources);
            }
            return cachedCanExecute;
        }
        return false;
    }

    private static boolean areStyleProviders(Resource[] resources) throws DatabaseException, InterruptedException {
        return RequestUtil.trySyncRequest(
                Simantics.getSession(),
                SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT,
                SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT,
                false,
                new StyleProviderCheck(Arrays.asList(resources)));
    }

    private static class StyleProviderCheck extends UnaryRead<List<Resource>, Boolean> {

        public StyleProviderCheck(List<Resource> parameter) {
            super(parameter);
        }

        @Override
        public Boolean perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance(graph);
            // Find what kind of styles selected objects support
            for (Resource r : parameter)
                if (!graph.isInstanceOf(r, DIA.StyleProvider))
                    return false;
            return true;
        }

    }

    @Execute
    public void execute(@Named(IServiceConstants.ACTIVE_SELECTION) ISelection s) {
        final Resource[] resources = ResourceAdaptionUtils.toResources(s);
        if (resources.length != 0)
            EditStyle.openStyleDialog(resources);
    }

}
