/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.IProject;
import org.simantics.ui.contribution.OperationsMenuContribution;

/**
 * @author Tuukka Lehtonen
 */
public class ModelingProjectOperationsContribution extends OperationsMenuContribution {

    @Override
    protected Object[] getSelectedObjects() {
        // Force the evaluated selection to be the currently active project.
        IProject project = Simantics.peekProject();
        if (project == null)
            return Resource.NONE;
        return new Resource[] { project.get() };
    }

    @Override
    protected Resource getListResource(ReadGraph g) throws Exception {
		return ModelingResources.getInstance(g).ModelingOperations;
    }

}
