package org.simantics.modeling.ui.actions;

import gnu.trove.set.hash.THashSet;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.flags.MergeFlags;
import org.simantics.utils.ui.ExceptionUtils;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
public class MergeFlagsAction implements ActionFactory {
    
    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;

        Resource composite = (Resource) target;
        final THashSet<Resource> composites = new THashSet<Resource>();
        composites.add(composite);

        return new Runnable() {
            @Override
            public void run() {
                try {
                    IRunnableWithProgress runnable = new IRunnableWithProgress() {
                        @Override
                        public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            final SubMonitor submonitor = SubMonitor.convert(monitor, Messages.MergeFlagsAction_MonitorMergeFlags, 1000);
                            try {
                                Simantics.getSession().sync(new WriteRequest() {
                                    @Override
                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        graph.markUndoPoint();
                                        
                                        SubMonitor expand = submonitor.newChild(10);
                                        expand.subTask(Messages.MergeFlagsAction_ExpandCompositeSet);
                                        MergeFlags.expandCompositeSet(graph, composites);
                                        if (monitor.isCanceled())
                                            throw new CancelTransactionException();
                                        expand.done();

                                        SubMonitor collect = submonitor.newChild(490);
                                        collect.subTask(Messages.MergeFlagsAction_CollectFlag);
                                        collect.setWorkRemaining(composites.size());
                                        ArrayList<ArrayList<Resource>> groups = new ArrayList<ArrayList<Resource>>(); 
                                        for(Resource composite : composites) {
                                            MergeFlags.collectFlagGroupsInComposite(graph, composite, groups);
                                            if (monitor.isCanceled())
                                                throw new CancelTransactionException();
                                            collect.worked(1);
                                        }
                                        collect.done();

                                        SubMonitor merge = submonitor.newChild(500);
                                        merge.subTask(Messages.MergeFlagsAction_MonitorMergeCollectedFlags);
                                        merge.setWorkRemaining(composites.size());
                                        for(ArrayList<Resource> group : groups) {
                                            MergeFlags.merge(graph, group);
                                            if (monitor.isCanceled())
                                                throw new CancelTransactionException();
                                            merge.worked(1);
                                        }
                                        merge.done();
                                    }
                                });
                            } catch (CancelTransactionException e) {
                            } catch (DatabaseException e) {
                                throw new InvocationTargetException(e);
                            } finally {
                                monitor.done();
                            }
                        }
                    };

                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new ProgressMonitorDialog(shell).run(true, true, runnable);
                } catch (InvocationTargetException e) {
                    ExceptionUtils.logAndShowError(e.getTargetException());
                } catch (InterruptedException e) {
                }
            }
        };
    }

}
