package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardCutHandler;

public class Cut implements ActionFactory, ActionFactory2 {

	@Override
    public Runnable create(Object target) {
		return create(Collections.singletonList(target));
	}

	@Override
    public Runnable create(Collection<?> target) {

		final ArrayList<Resource> resources = new ArrayList<Resource>();
		
		for(Object o : target) {
			if(!(o instanceof Resource))
				return null;
			resources.add((Resource)o);
		}
        
        return new Runnable() {
            @Override
            public void run() {
            	
            	StandardCutHandler.cutResourcesToClipboard(resources.toArray(new Resource[resources.size()]), null);
            	
            }
        };
    }

}
