package org.simantics.modeling.ui.viewpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 */
public class VariableChildren {

    /**
     * @param graph
     * @param variables
     * @param requiredClassification
     * @return
     * @throws DatabaseException
     */
    public static Collection<Variable> filterByClassification(ReadGraph graph, Collection<Variable> variables, String requiredClassification) throws DatabaseException {
        if (variables.isEmpty())
            return Collections.emptyList();
        Collection<Variable> result = null;
        for (Variable v : variables) {
            //System.out.println("child : " + v.getURI(graph));
            Set<String> classifications = v.getClassifications(graph);
            //System.out.println("classifications: " + classifications);
            if (classifications != null && classifications.contains(requiredClassification)) {
                if (result == null)
                    result = new ArrayList<Variable>(variables.size());
                result.add(v);
            }
        }
        return result != null ? result : Collections.<Variable>emptyList();
    }

}
