package org.simantics.modeling.ui.viewpoint;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.stubs.StructuralResource2;

public class VariableChildRule implements ChildRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent)
            throws DatabaseException {
        Collection<Variable> children = ((Variable)parent).getChildren(graph);
        return VariableChildren.filterByClassification(graph, children, StructuralResource2.URIs.Component);
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
        Variable parent = ((Variable)child).getParent(graph);
        if(parent == null)
            return Collections.emptyList();
        else
            return Collections.singleton(parent);
    }


}
