/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SCLScriptEditorAdapter extends AbstractResourceEditorAdapter implements EditorAdapter {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptEditorAdapter.class);
    
    public SCLScriptEditorAdapter() {
        super("SCL Script Editor", null, 20);
    }

    private Resource toResource(Object input) {
        if (input instanceof IStructuredSelection)
            input = ((IStructuredSelection)input).getFirstElement();
        if (!(input instanceof Resource)) {
            if(input instanceof IAdaptable) {
                input = ((IAdaptable)input).getAdapter(Resource.class);
                if (input == null)
                    return null;
            }
            else
                return null;
        }
        return (Resource) input;
    }

    @Override
    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        Resource resource = toResource(input);
        return resource != null && g.isInstanceOf(resource, Layer0.getInstance(g).SCLScript);
    }

    protected void openEditor(Resource input) throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null)
            return;
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                String uri = graph.getURI(input);
                PlatformUI.getWorkbench().getDisplay().asyncExec(openEditor(uri));
            }
        });
    }

    private static Runnable openEditor(String uri) {
        return () -> {
            try {
                WorkbenchUtils.openEditor("org.simantics.modeling.ui.scl.scriptEditor", new SCLScriptEditorInput(uri));
            } catch (PartInitException e) {
                LOGGER.error("Could not initialize part", e);
            }
        };
    }

}
