/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
class ReadSCLScriptSource extends UnaryRead<String, SCLScriptSource> {

    public ReadSCLScriptSource(String scriptURI) {
        super(scriptURI);
    }

    @Override
    public SCLScriptSource perform(ReadGraph graph) throws DatabaseException {
        return new SCLScriptSource(
                parameter,
                graph.syncRequest(new ReadSCLScriptDefinition(parameter)));
    }

}