/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.modelBrowser2.model.SubscriptionNode;
import org.simantics.structural.ui.modelBrowser.contributions.LibraryViewpointContributor;

public class SubscriptionItems extends LibraryViewpointContributor<SubscriptionNode> {

    @Override
    public Read<Collection<Resource>> getChildRequest(ReadGraph graph, SubscriptionNode subscription) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(graph);
        ModelingResources mr = ModelingResources.getInstance(graph);
        return new ObjectsWithType(subscription.resource, b.ConsistsOf, mr.Subscription_Item);
    }

}
