package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.requests.SetSubscriptionEnabled;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class SetSubscriptionEnabledContribution extends DynamicMenuContribution implements IExecutableExtension {

    String          name    = "";
    ImageDescriptor image   = null;
    boolean         include = true;

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
    throws CoreException {
        if (data instanceof Map<?,?>) {
            @SuppressWarnings("unchecked")
            Map<String, String> args = (Map<String, String>) data;
            name = args.get("name");
            String imageId = args.get("image");
            image = Activator.getDefault().getImageRegistry().getDescriptor(imageId);
            include = Boolean.parseBoolean(args.get("include"));
        }
    }

    private Collection<Resource> toSubscriptions(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance(graph);

        Set<Resource> result = new HashSet<Resource>(resources.size());
        for (Resource o : resources) {
            if (graph.isInstanceOf(o, mod.Subscription))
                result.add(o);
        }

        return result;
    }

    @Override
    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources(getSelection());
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] elements) throws DatabaseException {
        final Resource[] resources = (Resource[]) elements;
        if (resources.length == 0)
            return new IContributionItem[0];

        // Are there any components in the selection whose inclusion state
        // is different from the argument 'included'?
        final Collection<Resource> subscriptions = toSubscriptions(graph, Arrays.asList(resources));
        if (subscriptions.isEmpty())
            return new IContributionItem[0];

        ModelingResources mod = ModelingResources.getInstance(graph);

        boolean foundNonMatchingEnableStates = false;
        for (Resource subscription : subscriptions) {
            Boolean isIncluded = graph.getPossibleRelatedValue(subscription, mod.Subscription_Enabled);
            if (isIncluded == null)
                isIncluded = Boolean.TRUE;
            if (isIncluded != include)
                foundNonMatchingEnableStates = true;
        }
        if (!foundNonMatchingEnableStates)
            return new IContributionItem[0];

        return new IContributionItem[] {
                new ActionContributionItem(new Action(name, image) {
                    @Override
                    public void run() {
                        Session session = Simantics.peekSession();
                        if (session == null)
                            return;

                        Simantics.getSession().asyncRequest(new WriteRequest() {
                            @Override
                            public void perform(WriteGraph graph) throws DatabaseException {
                                new SetSubscriptionEnabled(subscriptions, include).perform(graph);
                            }
                        });
                    }
                })
        };
    }

}
