/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Tuukka Lehtonen
 */
public enum IsComponentTest implements Test {

	INSTANCE;

	public static IsComponentTest get() {
		return INSTANCE;
	}

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return Variable.class.equals(contentType) ||
				Resource.class.equals(contentType);
	}

	@Override
	public boolean test(ReadGraph graph, Object content) throws DatabaseException {
		if (content instanceof Variable) {
			Variable v = (Variable) content;
			//System.out.println("Test variable: " + v.getURI(graph));
			StructuralResource2 STR = StructuralResource2.getInstance(graph);
			Resource type = v.getPossibleType(graph, STR.Component);
			//System.out.println("variable component type: " + NameUtils.getURIOrSafeNameInternal(graph, type));
			return type != null;
		} else if (content instanceof Resource) {
			Resource r = (Resource) content;
			//System.out.println("Test resource: " + NameUtils.getURIOrSafeNameInternal(graph, r));
			StructuralResource2 STR = StructuralResource2.getInstance(graph);
			Resource type = graph.getPossibleType(r, STR.Component);
			//System.out.println("resource component type: " + NameUtils.getURIOrSafeNameInternal(graph, type));
			return type != null;
		}
		return false;
	}

}
