/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;

@Deprecated
public class Subscriptions extends Node {

    public Subscriptions(Resource resource) {
        super(resource);
    }

    @Override
    public Resource getResource() {
        return resource;
    }

    @Override
    public String getLabel(ReadGraph g)
    {
        return "Subscriptions";
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
        ModelingResources mr = ModelingResources.getInstance(g);
        Collection<INode> ret = new ArrayList<INode>();
        for (Resource r : g.getObjects(resource, b.ConsistsOf)) {
            if (g.isInstanceOf(r, mr.Subscription)) {
                ret.add(g.adapt(r, INode.class));
            }
        }
        return ret;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.CHARTGROUP_ICON;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getAdapter(Class adapter) {
        // deny adaptability, prevent showing of properties this way.
        return null;
    }

}