/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.Activator;

@Deprecated
public class Composite extends Node {
	
	public Composite(ReadGraph g, Resource resource) {
		super(resource);
	}

	@Override
	public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
		Collection<INode> ret = new ArrayList<INode>();
    	Layer0 b = Layer0.getInstance(g);
		for(Resource r : g.getObjects(resource, b.ConsistsOf))
			ret.add(g.adapt(r, INode.class));
		return ret;
	}

	@Override
	public ImageDescriptor getImage(ReadGraph g) {
		return Activator.COMPOSITE_ICON;
	}
		
}