/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.genericfileimport.wizard;

import java.io.File;
import java.util.Deque;

import org.simantics.db.management.ISessionContext;
import org.simantics.project.IProject;

/**
 * @author Antti Villberg
 */
public class GenericFileImportPlan {

    // Input
    ISessionContext sessionContext;
    IProject        project;
    Deque<String>   recentLocations;

    // Output
    File            importLocation;

    public GenericFileImportPlan(ISessionContext sessionContext, Deque<String> recentLocations) {
        this.sessionContext = sessionContext;
        this.recentLocations = recentLocations;
    }
    
    public ISessionContext getSessionContext(){
    	return sessionContext;
    }
    
    public void setProject(IProject project){
    	this.project = project;
    }
    
    public IProject getProject(){
    	return project;
    }

    public Deque<String> getRecentLocations(){
    	return recentLocations;
    }
    
    public File getImportLocation(){
    	return importLocation;
    }

    public void setImportLocation(File importLocation){
    	this.importLocation = importLocation;
    }
}