package org.simantics.modeling.ui.documents;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class OpenPlainTextDocumentAdapter extends AbstractResourceEditorAdapter {

    public OpenPlainTextDocumentAdapter() {
        super("Text Editor", Activator.COMPOSITE_ICON);
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
    	DocumentResource DOC = DocumentResource.getInstance(g);
        return g.isInstanceOf(r, DOC.PlainTextDocument);
    }

    @Override
    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph g) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance(g);
            	DocumentResource DOC = DocumentResource.getInstance(g);
                String documentName = g.getPossibleRelatedValue(r, L0.HasName);
                if (documentName == null)
                    documentName = "";
                final String text = g.getPossibleRelatedValue(r, DOC.PlainTextDocument_text, Bindings.STRING);
                if (text == null)
                    return;

                try {
                	final Resource model = g.syncRequest(new PossibleTypedParent(r, SimulationResource.getInstance(g).Model));
                	final String dir = model == null ? "" + r.getResourceId() : (String)(g.getRelatedValue(model, L0.HasName));
                    IPath state = Platform.getStateLocation(Platform.getBundle(Activator.PLUGIN_ID));
                    final File stateDir = new File(state.toFile(), dir);
                    stateDir.mkdirs();
                    final File tempFile = new File(stateDir, FileUtils.escapeFileName(documentName) + ".txt");
                    FileUtils.writeFile(tempFile, text.getBytes("US-ASCII"));

                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                final IEditorPart editor = IDE.openEditor(page, tempFile.toURI(), EditorsUI.DEFAULT_TEXT_EDITOR_ID, true);
                                page.addPartListener(new IPartListener() {
                                    @Override
                                    public void partOpened(IWorkbenchPart part) {
                                    }
                                    @Override
                                    public void partDeactivated(IWorkbenchPart part) {
                                    }
                                    @Override
                                    public void partClosed(IWorkbenchPart part) {
                                        if (part == editor) {
                                            page.removePartListener(this);
                                            if (!PlatformUI.getWorkbench().isClosing()) {
                                                try {
                                                    FileUtils.deleteAll(stateDir);
                                                } catch (IOException e) {
                                                    ErrorLogger.defaultLogError(e);
                                                }
                                            }
                                        }
                                    }
                                    @Override
                                    public void partBroughtToTop(IWorkbenchPart part) {
                                    }
                                    @Override
                                    public void partActivated(IWorkbenchPart part) {
                                    }
                                });
                            } catch (Exception e) {
                                ErrorLogger.defaultLogError(e);
                            }
                        }
                    });
                } catch (IOException e1) {
                    ErrorLogger.defaultLogError(e1);
                }
            }
        });
    }

}
