/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.tools;

import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * Interface for diagramming tools
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface DiagramTools {
	
	/**
	 * Name that is show to user.
	 * @return
	 */
	public String getName();
	
	/**
	 * Create UI
	 * @param parent
	 */
	void createContols(Composite parent, FormToolkit toolkit, LocalResourceManager resourceManager);
	
	void setSelection(ISelection selection);
	
	/**
	 * Dispose.
	 */
	void dispose();

}
