/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.ArrayList;
import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.actions.DisconnectFlag;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class DisconnectFlagHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        final Set<Resource> resources = ISelectionUtils.filterSetSelection(sel, Resource.class);
        if (resources.isEmpty())
            return null;

        Job job = new DatabaseJob("Disconnect Flags") {
            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.getSession().syncRequest(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            DisconnectFlag.disconnectFlags(graph, new ArrayList<>(resources));
                        }
                    });
                    return Status.OK_STATUS;
                } catch (DatabaseException e) {
                    return new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to disconnect flags.", e); 
                }
            }
        };
        job.schedule();
        return null;
    }

}
