/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AlignHorizontalHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		
		ISelection s = HandlerUtil.getCurrentSelectionChecked(event);
		final Resource resources[] = ResourceAdaptionUtils.toResources(s);
		
		if (resources.length < 2)
			return null;
		
		Simantics.getSession().asyncRequest(new WriteRequest() {
			
			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				DiagramResource dr = DiagramResource.getInstance(graph);
				
				List<Resource> elements = new ArrayList<Resource>();
				List<double[]> transforms = new ArrayList<double[]>();
				for (Resource r : resources) {
					//System.out.println(r + " " + GraphUtils.getReadableName(graph, r));
					if (graph.isInstanceOf(r, dr.Element) && !graph.isInstanceOf(r, dr.Connection)) {
						
						double transform[] = graph.getPossibleRelatedValue(r, dr.HasTransform);
						if (transform != null) {
							elements.add(r);
							transforms.add(transform);
						}
					}
				}
				double mx = 0;
				double my = 0;
				for (double[] t : transforms) {
					mx += t[4];
					my += t[5];
				}
				mx /= transforms.size();
				my /= transforms.size();
				
				// prevent moving symbols into the same position
				int count = 0;
				for (double t[] : transforms) {
					if (Math.abs(t[4] - mx) < 0.1) {
						count++;
					}
				}
				if (count > 1)
					return;
				
				for (int i = 0; i < transforms.size(); i++) {
					Resource element = elements.get(i);
					double t[] = transforms.get(i);
					graph.claimLiteral(element, dr.HasTransform, new double[]{t[0],t[1],t[2],t[3],t[4],my});
				}
			}
		});
		
		return null;
	}

}
