/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PartInitException;
import org.simantics.modeling.ui.diagramEditor.tools.AlignTools;
import org.simantics.modeling.ui.diagramEditor.tools.DiagramToolViewPart;

public class AlignHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		AlignTools tool = new AlignTools();
		try {
			DiagramToolViewPart.open(tool);
		} catch (PartInitException e) {
			throw new ExecutionException("Could not show align tool", e);
		}
		return null;
	}
}
