/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation, gitlab #399
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor;

import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.utils.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 1.41.0, 1.35.2
 * @see gitlab #399
 */
class HasDiagramSourceListener extends DisposableListener<Resource> {

    private static final Logger LOGGER = LoggerFactory.getLogger(HasDiagramSourceListener.class);

    private DataContainer<IDiagram> diagramContainer;

    public HasDiagramSourceListener(DataContainer<IDiagram> diagramContainer) {
        this.diagramContainer = diagramContainer;
    }

    @Override
    public void execute(Resource source) {
        DataContainer<IDiagram> c = diagramContainer;
        IDiagram d = c != null ? diagramContainer.get() : null;
        if (d != null) {
            ElementUtils.setOrRemoveHint(d, DiagramModelHints.KEY_HAS_DIAGRAM_SOURCE, source);
        }
    }

    @Override
    public void exception(Throwable t) {
        LOGGER.error("Received unexpected exception", t);
    }

    @Override
    public void dispose() {
        super.dispose();
        diagramContainer = null;
    }

}
