/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.IToolMode;

/**
 * @author Tuukka Lehtonen
 */
public class EditorState {

    public AffineTransform viewTransform;

    public Set<Resource>   selection = Collections.emptySet();

    public String          toolMode;

    public IToolMode toToolMode() {
        if (Hints.POINTERTOOL.getId().equals(toolMode))
            return Hints.POINTERTOOL;
        else if (Hints.PANTOOL.getId().equals(toolMode))
            return Hints.PANTOOL;
        else if (Hints.CONNECTTOOL.getId().equals(toolMode))
            return Hints.CONNECTTOOL;
        return null;
    }

}
