package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.SWTUtils;

public class SymbolCodeDocumentProvider2 extends SCLModuleEditorDocumentProvider {

    Display display;
    SCLModuleEditor editor;

    public SymbolCodeDocumentProvider2(SCLSourceViewerConfigurationNew sourceViewer, Display display, SCLModuleEditor editor) {
        super(sourceViewer);
        this.display = display;
        this.editor = editor;
    }

    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        resource = input.getResource();
        try {
            return Simantics.getSession().syncRequest(new UniqueRead<Document>() {
                @Override
                public Document perform(ReadGraph graph) throws DatabaseException {
                	return new Document(getText(graph));
                }
            });
        } catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return new Document(sw.toString());
        }
    }
    
    private String getText(ReadGraph graph) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	DiagramResource DIA = DiagramResource.getInstance(graph);
    	for(Resource text : graph.getAssertedObjects(resource, DIA.symbolCode)) {
    		errorHappened = false;
    		return graph.getRelatedValue(text, L0.SCLValue_expression, Bindings.STRING);
    	}
    	return ""; //$NON-NLS-1$
    }

    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest(new ResourceRead<TextAndErrors>(resource) {
            @Override
            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                return new TextAndErrors(getText(graph), CompilationError.EMPTY_ARRAY);
            }
        }, new Listener<TextAndErrors>() {
            @Override
            public void execute(final TextAndErrors textAndErrors) {
                if (editor.isDisposed())
                    return;
                SWTUtils.asyncExec(display, new Runnable() {
                    @Override
                    public void run() {
                        if (editor.isDisposed())
                            return;
                        if(textAndErrors.errors.length > 0) {
                            setAnnotations(Arrays.asList(textAndErrors.errors));
                        } else {
                            setAnnotations(Collections.<CompilationError>emptyList());
                        }
                    }
                });
            }

            @Override
            public void exception(Throwable t) {
                Activator.getDefault().getLog().log(
                        new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.SymbolCodeDocumentProvider2_ActivatorInternalErrorInCodeCompilation, t));
            }

            @Override
            public boolean isDisposed() {
                return editor.isDisposed();
            }
        });
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog(getClass(), "doSaveDocument"); //$NON-NLS-1$
        currentText = document.get();
        Simantics.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
            	Layer0 L0 = Layer0.getInstance(graph);
            	DiagramResource DIA = DiagramResource.getInstance(graph);
            	Collection<Resource> ass = graph.getAssertedObjects(resource, DIA.symbolCode);
            	if(ass.size() == 0) {
            		
            		ModelingResources MOD = ModelingResources.getInstance(graph);
            		Resource newValue = graph.newResource();
            		graph.claim(newValue, L0.InstanceOf, MOD.SCLValue);
            		graph.claimLiteral(newValue, L0.HasValueType, "[String]", Bindings.STRING); //$NON-NLS-1$
            		graph.claimLiteral(newValue, L0.SCLValue_expression, currentText, Bindings.STRING);
                	
                	Layer0Utils.assert_(graph, resource, DIA.symbolCode, newValue);
                	return;

            	}
            	
            	for(Resource text : ass) {
            		graph.claimLiteral(text, L0.SCLValue_expression, currentText, Bindings.STRING);
            		return;
            	}
            	
            }
        });
    }

}
