/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Widget;
import org.simantics.browsing.ui.swt.widgets.Scale;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

/**
 * @author Tuukka Lehtonen
 */
public class DelayedIntegerToDoublePropertyModifier extends SelectionListenerImpl<Resource> {

    private final Scale slider;
    private final String propertyURI;
    private int selection;

    public DelayedIntegerToDoublePropertyModifier(Scale slider, ISessionContext context, String propertyURI) {
        super(context);
        this.slider = slider;
        this.propertyURI = propertyURI;
    }

    @Override
    public void beforeApply() {
        this.selection = slider.getWidget().getSelection();
    }

    @Override
    public void apply(WriteGraph graph, Resource input) throws DatabaseException {
        graph.claimLiteral(input, graph.getResource(propertyURI), (double) selection, Bindings.DOUBLE);
    }

    private void super$widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
    }

    int modCount = 0;

    @Override
    public void widgetSelected(final SelectionEvent e) {
        final int mod = ++modCount;
        final Widget widget = slider.getWidget();
        widget.getDisplay().timerExec(250, new Runnable() {
            @Override
            public void run() {
                if (widget.isDisposed() || mod != modCount)
                    return;
                super$widgetSelected(e);
            }
        });
    }

}
