package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.structural.stubs.StructuralResource2;

public class UnlockAction implements ActionFactory {

    @Override
    public Runnable create(Object target) {

        if (!(target instanceof Resource))
            return null;

        final Resource resource = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                try {
                    Simantics.getSession().markUndoPoint();
                    Simantics.getSession().syncRequest(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            StructuralResource2 STR = StructuralResource2.getInstance(graph);
                            graph.deny(resource, STR.ComponentType_Locked);
                        }
                    });
                } catch (DatabaseException e) {
                    Logger.defaultLogError(e);
                }
            }
        };
    }

}
