/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceScopes;
import org.simantics.browsing.ui.platform.PropertyPageView;

public class PinSelectionHandler extends AbstractHandler implements IElementUpdater {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked(event);
        if (!(part instanceof PropertyPageView))
            return null;

        PropertyPageView ppv = (PropertyPageView) part;
        ppv.pinWorkbenchSelection(!ppv.isWorkbenchSelectionPinned());

        return null;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPartSite site = (IWorkbenchPartSite) parameters.get(IServiceScopes.PARTSITE_SCOPE);
        if (site != null) {
            IWorkbenchPart part = site.getPart();
            if (part instanceof PropertyPageView) {
                PropertyPageView ppv = (PropertyPageView) part;
                element.setChecked(ppv.isWorkbenchSelectionPinned());
            }
        }
    }

}
