package org.simantics.modeling.ui.actions;

import java.util.UUID;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.commandlog.NewSubscriptionCommand;
import org.simantics.utils.commandlog.Commands;

/**
 * @author Tuukka Lehtonen
 */
public class NewSubscription implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;
        final Resource model = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        
                        Layer0 l0 = Layer0.getInstance(g);
                        ModelingResources wr = ModelingResources.getInstance(g);
                        String freshLabel = NameUtils.findFreshLabel(g, Messages.NewSubscription_Subscription, model);
                        @SuppressWarnings("unused")
                        Resource subscription = GraphUtils.create2(g, wr.Subscription,
                                l0.HasName, UUID.randomUUID().toString(),
                                l0.HasLabel, freshLabel,
                                l0.PartOf, model);
                        if(Commands.isRecording())
                            Commands.record(g, new NewSubscriptionCommand(subscription, model, Messages.NewSubscription_Subscription));

                        CommentMetadata cm = g.getMetadata(CommentMetadata.class);
                        g.addMetadata(cm.add("Created subscription folder " + freshLabel)); //$NON-NLS-1$
                    }
                });
            }
        };
    }

}
