/*******************************************************************************
 * Copyright (c) 2017, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semamtum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.ui.wizard.MigrateWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Antti Villberg
 */
public class MigrateComponentType implements ActionFactory {

	private static final Logger LOGGER = LoggerFactory.getLogger(MigrateComponentType.class);

	@Override
	public Runnable create(Object target) {

		if (!(target instanceof Resource))
			return null;

		final Resource r = (Resource)target;

		return new Runnable() {

			@Override
			public void run() {

				try {

					final String initial = Simantics.sync(new ResourceToPossibleURI(r));

					Display.getDefault().asyncExec(new Runnable() {

						@Override
						public void run() {

							final int SIZING_WIZARD_WIDTH  = 500;
							final int SIZING_WIZARD_HEIGHT = 600;
							IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
							MigrateWizard wizard = new MigrateWizard(initial);
							WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
							dialog.create();
							dialog.getShell().setSize(Math.max(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().x), SIZING_WIZARD_HEIGHT);
							dialog.open();

						}

					});

				} catch (DatabaseException e) {
					LOGGER.error("Component type migration failed", e);
				}

			}

		};

	}

}
