/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.modeling.ModelingOperationConstants;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.contribution.OperationsMenuContribution;
import org.simantics.utils.datastructures.persistent.ContextMap;

public class DiagramOperationsContribution extends OperationsMenuContribution {

    IWorkbenchWindow window;
    IWorkbenchPart part;

    @Override
    public void fill(Menu menu, int index) {
        window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        part = window.getActivePage().getActivePart();
        if (part == null)
            return;

        super.fill(menu, index);
    }

    @Override
    protected void assignParameters(ContextMap parameters) {
        parameters.put(ModelingOperationConstants.WORKBENCH_WINDOW, window);
        parameters.put(ModelingOperationConstants.WORKBENCH_PART, part);
    }

    @Override
    protected Resource getListResource(ReadGraph g) throws Exception {
        return g.getResource(ModelingResources.URIs.DiagramOperations);
    }

}
