package org.simantics.modeling.ui.actions;

import java.util.Collection;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * This class exists as a org.eclipse.ui.handler extension point counterpart for
 * AssignSymbolGroup ActionFactory due to lack of multi-selection support in the
 * modeled {@link ActionFactory} contributions.
 * 
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class AssignSymbolGroupsHandler extends AbstractHandler {

	public static Object handleStatic(Collection<Resource> res) throws ExecutionException {
		return executeImpl(res);
	}
	
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection s = HandlerUtil.getCurrentSelection(event);
		if (!(s instanceof IStructuredSelection))
			return null;

		Collection<Resource> res = ISelectionUtils.getPossibleKeys(s, SelectionHints.KEY_MAIN, Resource.class);
		return executeImpl(res);
	}
	
	private static Object executeImpl(Collection<Resource> res) throws ExecutionException {
		if (!res.isEmpty())
			new AssignSymbolGroup().assignGroups(res);
		return null;
	}

}
