package org.simantics.modeling.ui;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.actions.NewLibrary;
import org.simantics.modeling.ui.actions.NewLocalLibrary;

public class SCLLibrary {
	
	public static Resource createLibrary(Resource parent) throws DatabaseException {
		
		NewLibrary lib = new NewLibrary();
		Resource library = lib.newLibrary(parent);
		return library;
	}
	
	public static Resource createLibraryInModel(Resource model) throws DatabaseException {
		
		NewLocalLibrary lib = new NewLocalLibrary();
		Resource library = lib.newLibrary(model);
		return library;
	}
	
	public static Resource getLibrary (ReadGraph graph, Resource model, String name) throws DatabaseException {
		if (name.isEmpty()) {
			ModelingResources MOD = ModelingResources.getInstance(graph);
			Resource library = graph.getPossibleObject(model, MOD.HasLocalLibrary);
			return library;
		} else {
			Layer0 L0 = Layer0.getInstance(graph);
			Collection<Resource> libraries = graph.syncRequest(new ObjectsWithType(model, L0.ConsistsOf, L0.Library));
			for (Resource library : libraries) {
				String name1 = graph.getPossibleRelatedValue2(library, L0.HasName);
				if (name1 != null && name1.equals(name)) {
					return library;
				}
			}
		}
		return null;
	}
}