package org.simantics.modeling.ui.viewpoint;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

public class ChildrenInActiveExperiment implements ChildRule {

    Layer0 L0;
    SimulationResource SIMU;
    StructuralResource2 STR;
    
    public ChildrenInActiveExperiment(ReadGraph graph) {
        this.L0 = Layer0.getInstance(graph);
        this.SIMU = SimulationResource.getInstance(graph);
        this.STR = StructuralResource2.getInstance(graph);
    }

    private Variable getVariable(ReadGraph graph, Resource r) throws DatabaseException {
        Resource model = graph.getPossibleObject(r, SIMU.IsConfigurationOf);
        if(model != null) {
            return (Variable)graph.adapt(SIMU.ActiveExperiment, Function.class)
                .apply(graph, model);
        }
        String name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
        Resource parent = graph.getPossibleObject(r, L0.PartOf);
        if(name == null || parent == null)
            return null;
        Variable parentVariable = getVariable(graph, parent);
        if(parentVariable == null)
            return null;
        return parentVariable.getPossibleChild(graph, name);
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent_)
            throws DatabaseException {
        Resource parent = (Resource)parent_;
        if(graph.isInstanceOf(parent, STR.Composite))
            return Collections.emptyList();
        Variable variable = getVariable(graph, parent);
        if(variable == null)
            return Collections.emptyList();
        Collection<Variable> children = variable.getChildren(graph);
        return VariableChildren.filterByClassification(graph, children, StructuralResource2.URIs.Component);
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
        return Collections.emptyList();
    }

}
