/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.typicals;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * Creates a new master typical diagram and its corresponding composites.
 * 
 * <p>
 * The created typical composite and diagram type are specified by the model
 * using {@link ModelingResources#StructuralModel_HasTypicalCompositeBaseType}
 * and {@link ModelingResources#StructuralModel_HasTypicalDiagramBaseType}.
 * 
 * <p>
 * Marks the created master composite with the model-specified master composite
 * type to support searching. The master type is specified by the model using
 * {@link ModelingResources#StructuralModel_HasMasterTypicalCompositeType}.
 * 
 * <p>
 * Clones symbol contributions from the sources specified by the model through
 * {@link ModelingResources#StructuralModel_CloneTypicalDiagramSymbolContributionsFrom}
 * .
 * 
 * @author Tuukka Lehtonen
 */
public class NewMasterTypicalDiagram implements ActionFactory {

    @Override
    public Runnable create(Object target_) {
        final Resource target = (Resource)target_;
        return new Runnable() {
            @Override
            public void run() {
            	try {
            		PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress() {
            			@Override
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            				try {
            					Resource composite = TypicalUtil.newMasterTypical(target);
            					
            	                // Perform default action on the newly created diagram
            	                performDefaultAction(Simantics.getSession(), composite);
            				} catch (DatabaseException e) {
            					throw new InvocationTargetException(e);
            				} finally {
            					monitor.done();
            				}
            			}
            		});
            	} catch (InvocationTargetException e) {
            		ErrorLogger.defaultLogError(e.getCause());
            	} catch (InterruptedException e) {
            		ErrorLogger.defaultLogError(e);
            	}
            }
        };
    };

    private static void performDefaultAction(final Session session, final Object input) {
        SWTUtils.asyncExec(PlatformUI.getWorkbench().getDisplay(), new Runnable() {
            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Shell shell = window != null ? window.getShell() : null;
                session.asyncRequest(new ChooseActionRequest(shell, null, input, WorkbenchUtils.getCurrentPerspectiveId(), false, false, true));
            }
        });
    }

}
