/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.symbolEditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.handler.CopyOperation;
import org.simantics.diagram.handler.CopyStrategy;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.modeling.ui.Activator;

/**
 * The default strategy for pasting diagram elements.
 * 
 * @author Tuukka Lehtonen
 * @since 1.23
 */
public class SymbolEditorCopyPasteStrategy extends DefaultCopyPasteStrategy implements CopyStrategy {

    @Override
    public IStatus copy(CopyOperation operation) {
        try {
            Simantics.getSession().syncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                    // TODO: implement the necessary checks to prevent copying symbol terminals
                }
            });
            return Status.OK_STATUS;
        } catch (DatabaseException e) {
            IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                    "Failed to filter copied material.", e);
            Activator.getDefault().getLog().log(status);
            return status;
        }
    }

}