/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SCLScriptEditorInput implements IEditorInput, IPersistableElement {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptEditorInput.class);

    private final String scriptURI;

    public SCLScriptEditorInput(String scriptURI) {
        this.scriptURI = scriptURI;
    }

    public String getScriptURI() {
        return scriptURI;
    }

    @Override
    public boolean exists() {
        // Not worth it testing this from the database.
        return true;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(SCLScriptSource.class)) {
            try {
                return (T) Simantics.getSession().syncRequest(new ReadSCLScriptSource(scriptURI));
            } catch (DatabaseException e) {
                LOGGER.error("Failed to read SCL script source", e);
            }
        }
        if (adapter.equals(IPersistableElement.class))
            return (T) this;
        return null;
    }

    @Override
    public String getFactoryId() {
        return "org.simantics.modeling.ui.scl.scriptEditor.inputFactory";
    }

    @Override
    public String getName() {
        int p = scriptURI.lastIndexOf('/');
        if(p >= 0)
            return scriptURI.substring(p+1);
        else
            return scriptURI;
    }

    @Override
    public String getToolTipText() {
        return scriptURI;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public IPersistableElement getPersistable() {
        return this;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((scriptURI == null) ? 0 : scriptURI.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        SCLScriptEditorInput other = (SCLScriptEditorInput) obj;
        return scriptURI.equals(other.scriptURI);
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putTextData(scriptURI);
    }

}
