/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.property.svg;

import java.util.Set;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.image2.ontology.ImageResource;

/**
 * @author Antti Villberg
 */
public class SVGModifier extends TextModifyListenerImpl<SVGInput> {

    @Override
    public void applyText(WriteGraph graph, SVGInput ui, String text) throws DatabaseException {
        if (text == null)
            return;

        try {
            XMLPrettyPrinter.parseDocument(text);
        } catch (Exception e) {
            // Never write non-well-formed SVG into the database.
            return;
        }

        Resource resource = ui.getDatum();
        G2DResource G2D = G2DResource.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        ImageResource IMG = ImageResource.getInstance(graph);
        Set<Resource> types = graph.getTypes(resource);
        if(types.contains(DIA.SVGElement)) {
            graph.claimLiteral(resource, G2D.HasSVGDocument, text, Bindings.STRING);
        } else if(types.contains(IMG.SvgImage)) {
            graph.claimValue(resource, text, Bindings.STRING);
        }

   }

}