/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.label;

import java.util.Collections;
import java.util.Map;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.GraphHints;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.utils.format.ValueFormat;

/**
 * @author Tuukka Lehtonen
 */
public class SubscriptionItemLabelRule implements LabelRule {

    public static final SubscriptionItemLabelRule INSTANCE = new SubscriptionItemLabelRule();

    ValueFormat valueFormat;

    public SubscriptionItemLabelRule() {
        IEclipsePreferences chartPreferenceNode = InstanceScope.INSTANCE.getNode( "org.simantics.charts" );
        String s = chartPreferenceNode.get("chart.valueformat", ValueFormat.Default.name());
        valueFormat = ValueFormat.valueOf( s );
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        GraphHints old = graph.setHintValue(ReadGraph.GRAPH_HINT_SYNCHRONOUS, true);
        try {
            Resource item = (Resource) content;
            String label = SubscriptionItemLabel.resolveLabel(graph, item, valueFormat, true);
            return Collections.singletonMap(ColumnKeys.SINGLE, label);
        } finally {
            graph.setHints(old);
        }
    }
}
