/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.label;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.browsing.ui.swt.Activator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.impl.RelatedEntityNameModifier;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ConnectionRelationStringModifierFactory;

/**
 * @author Tuukka Lehtonen
 * @see ConnectionRelationStringModifierFactory
 */
public class ConnectionRelationModifierRule implements ModifierRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Modifier getModifier(ReadGraph graph, Object content, String columnKey) throws DatabaseException {
        Resource connectionRelation = (Resource) content;

        // Always rename all (configuration and diagram) connection relations
        Layer0 L0 = Layer0.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Resource cr = graph.getPossibleObject(connectionRelation, MOD.DiagramConnectionRelationToConnectionRelation);
        Resource subject = cr != null ? cr : connectionRelation;
        Resource property = graph.getSingleObject(subject, L0.HasName);
        return new StringModifierAdapter(
                new RelatedEntityNameModifier(graph, subject, property, MOD.ConnectionRelationToDiagramConnectionRelation));
    }

    static class StringModifierAdapter implements Modifier {
        private StringModifier modifier;

        public StringModifierAdapter(StringModifier modifier) {
            this.modifier = modifier;
        }

        public void modify(final String label) {
            try {
                Simantics.getSession().syncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                        modifier.modify(graph, label);
                    }
                });
            } catch (DatabaseException e) {
                Activator.getDefault().getLog().log(
                        new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Name modification failed, see exception for details.", e));
            }
        }

        @Override
        public String isValid(String label) {
            return modifier.isValid(label);
        }

        @Override
        public String getValue() {
            return modifier.getValue();
        }
    }

}
