/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.RelatedValueImplied;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;

@Deprecated
public class Parameter extends Node implements IModifiable {

    Resource instance;
    Resource relation;
    Resource connectionType;
    Resource connectionDirection;
    boolean isLeaf;

    public Resource getTerminalRelation(ReadGraph graph, Resource relation) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance(graph);
        for(Resource bound : graph.getObjects(relation, sr.IsBoundBy)) {
            if(graph.isInstanceOf(bound, sr.Connection)) {
                for(Statement terminalInverse : graph.getStatements(bound, sr.IsConnectedTo)) {
                    if(graph.isInstanceOf(terminalInverse.getObject(), sr.Component)) {
                        return graph.getInverse(terminalInverse.getPredicate());
                    }
                }
            }
        }
        return null;
    }

    public Resource getConnectionType(ReadGraph graph, Resource connectionPoint) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance(graph);
        ModelingResources mr = ModelingResources.getInstance(graph);
        for(Resource bound : graph.getObjects(relation, sr.IsBoundBy)) {
            if(graph.isInstanceOf(bound, sr.Connection)) {
                Resource diagramConn = graph.getPossibleObject(bound, mr.ConnectionToDiagramConnection);
                if(diagramConn != null) {
                    return graph.getPossibleObject(diagramConn, sr.HasConnectionType);
                }
            }
        }
        return null;
    }

    public Parameter(ReadGraph g, Resource resource, Resource instance, boolean isLeaf) throws DatabaseException {
        super(resource);
        this.instance = instance;
        StructuralResource2 sr = StructuralResource2.getInstance(g);
        this.relation = g.getSingleObject(resource, sr.Binds);
//		this.connectionType = g.getPossibleObject(resource, sr.HasConnectionType);
        this.connectionDirection = g.getPossibleObject(resource, sr.HasConnectionDirection);
        this.isLeaf = isLeaf;
        this.connectionType = getConnectionType(g, relation);
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
        String name = g.getPossibleRelatedValue(relation, b.HasName);
        if(name == null)
            return "Unnamed parameter";
        if(connectionType != null) {
            name = name + " : " + NameUtils.getSafeName(g, connectionType);
            if(connectionDirection != null) {
                StructuralResource2 sr = StructuralResource2.getInstance(g);
                name = name + ", " +
                (sr.InputDirection.equals(connectionDirection) ? "in" :
                    sr.OutputDirection.equals(connectionDirection) ? "out" :
                        NameUtils.getSafeName(g, connectionDirection));
            }
        }
        return name;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) throws DatabaseException {
        /*StructuralResource2 sr = StructuralResource2.getInstance(g);
        if (g.isInstanceOf(resource, sr.LiteralVariable))
            return Activator.VARIABLE_ICON;*/
        return Activator.OPEN_CONNECTION_ICON;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(!getClass().equals(obj.getClass()))
            return false;
        Parameter other = (Parameter)obj;
        return resource.equals(other.resource)
        && relation.equals(other.relation)
        && (instance == null ? other.instance==null : instance.equals(other.instance))
        && isLeaf == other.isLeaf
        && (connectionType == null ? other.connectionType == null : connectionType.equals(other.connectionType));
    }

    @Override
    public int hashCode() {
        return ((getClass().hashCode()*31 + relation.hashCode()) * 31  +
                (instance == null ? 0 : instance.hashCode()))*31 + resource.hashCode();
    }    

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new Modifier() {

            @Override
            public String getValue() {
                try {
                	Layer0 b = Layer0.getInstance(session);
                    return session.syncRequest(new RelatedValueImplied<String>(relation, b.HasName));
                } catch (DatabaseException e) {
                    e.printStackTrace();
                    return "";
                }
            }

            @Override
            public String isValid(String label) {
                return null;
            }

            @Override
            public void modify(final String label) {
                session.asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(graph);
                        graph.claimLiteral(relation, b.HasName, label);
                    }

                });
            }

        };
    }
}
