/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.simulation.ontology.SimulationResource;

@Deprecated
public class Model extends Node implements IModifiable {

    final static boolean showFolders = true;

    Resource configuration;
    Session session;

    public Model(ReadGraph g, Resource resource) throws DatabaseException {
        super(resource);
        this.configuration = g.getPossibleObject(resource, SimulationResource.getInstance(g).HasConfiguration);
        this.session = g.getSession();
    }

    public File getModelDir() throws DatabaseException {
        IPath location = Platform.getLocation();
        File f = location.toFile();

        String modelName =
            (String) session.syncRequest(
                    org.simantics.db.common.request.Queries.getRelatedValue(resource, Layer0.URIs.HasName, Bindings.STRING));

        File modelDir = new File(f, modelName);
        return modelDir;
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
        Collection<Object> ret = new ArrayList<Object>(3);
        if(configuration != null) {
            ret.add(new Decorator(g.adapt(configuration, INode.class)) {
                @Override
                public String getLabel(ReadGraph g) {
                    return "Configuration";
                }
            });
        }
        ret.add(new Experiments(resource));
        ret.add(new States(resource));
//        ret.add(new Queries(g, resource));
        ret.add(new Charts(resource));
        ret.add(new Subscriptions(resource));
        ret.add(new Images(resource));
//        ret.add(new Spreadsheets(resource));
        ret.add(new RelationViews(resource));

        /*if(!showFolders) {
			ArrayList<Object> flatten = new ArrayList<Object>();
			for(INode n : ret)
				flatten.addAll(n.getChildren(g));
			return flatten;
		}*/
        return ret;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.MODEL_ICON;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(!getClass().equals(obj.getClass()))
            return false;
        Model other = (Model)obj;
        if(configuration == null) {
            return resource.equals(other.resource) && other.configuration == null;
        } else {
            return resource.equals(other.resource)
            && configuration.equals(other.configuration);
        }
    }

    @Override
    public int hashCode() {
        if(configuration == null) {
            return getClass().hashCode()*31 + resource.hashCode();
        } else {
            return (getClass().hashCode()*31
                    +  configuration.hashCode())*31 + resource.hashCode();
        }
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new LabelModifier(session, resource);
    }
}
