/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;

@Deprecated
public class Component extends PathNode implements IModifiable {

    Resource type;

    public Component(ReadGraph g, Resource resource) throws DatabaseException {
        super(resource);
        StructuralResource2 sr = StructuralResource2.getInstance(g);
        type = g.getSingleType(resource, sr.Component);
    }

    INode type(ReadGraph g) throws DatabaseException {
        return new ComponentType(g, type, resource);
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);

        StructuralResource2 sr = StructuralResource2.getInstance(g);
        Resource composite = g.getPossibleObject(type, sr.IsDefinedBy);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(new Interface(type, resource, true).getChildren(g));
        ResourceArray newPath = null;
        if(path != null) {
            newPath = path.appended(resource);
        } else {
            newPath = new ResourceArray(resource);
        }
        if(composite != null)
            for(Resource component : g.getObjects(composite, l0.ConsistsOf)) {
                INode node = g.getPossibleAdapter(component, INode.class);
                if (node != null) {
                    if(node instanceof IPathNode) {
                        ((IPathNode)node).setPath(newPath);
                    }
                    result.add(node);
                }
            }
        return result;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.COMPONENT_ICON;
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);
        String name = (String)g.getPossibleRelatedValue(resource, l0.HasName);
        if(name == null)
            name = "";
        return name + " : " + type(g).getLabel(g);
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(!getClass().equals(obj.getClass()))
            return false;
        Component other = (Component)obj;
        return resource.equals(other.resource)
        && type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return (getClass().hashCode()*31 + type.hashCode())*31 + resource.hashCode();
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new Modifier() {

            @Override
            public String getValue() {
                Read<String> request =
                    new Read<String>() {

                    @Override
                    public String perform(ReadGraph graph) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(graph);
                        String name = graph.getPossibleRelatedValue(resource, b.HasName);
                        return name != null ? name : "";
                    }

                };
                try {
                    return session.syncRequest(request);
                } catch (DatabaseException e) {
                    e.printStackTrace();
                    return "";
                }
            }

            @Override
            public String isValid(String label) {
                return null;
            }

            @Override
            public void modify(final String label) {
                session.asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	Layer0 b = Layer0.getInstance(graph);
                        graph.claimLiteral(resource, b.HasName, label);
                    }
                });
            }

        };
    }
}
