/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.EvaluatorImpl;
import org.simantics.browsing.ui.common.comparators.AlphanumericComparatorFactory;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.common.labelers.LabelerContent;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.common.viewpoints.ViewpointStub;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.browsing.ui.graph.impl.MissingImageDescriptor;
import org.simantics.browsing.ui.graph.impl.StringRepresentationLabelerFactory;
import org.simantics.browsing.ui.swt.OldAdapterImagerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.modelBrowser.model.IChildrenCallback;
import org.simantics.modeling.ui.modelBrowser.model.IDisposable;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.modeling.ui.modelBrowser.model.INode2;
import org.simantics.modeling.ui.modelBrowser.model.IUpdateable;
import org.simantics.utils.datastructures.UnaryFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
@Deprecated
public final class ModelEvaluators {

    public static UnaryFunction<Boolean, Object> passTester() {
        return new UnaryFunction<Boolean, Object>() {
            @Override
            public Boolean call(Object arg) {
                return Boolean.TRUE;
            }
        };
    }

    public static UnaryFunction<Boolean, Object> exactClassTester(final Class<?> ... classes) {
        final Set<Class<?>> classSet = new HashSet<Class<?>>();
        for(Class<?> clazz : classes) classSet.add(clazz);
        return new UnaryFunction<Boolean, Object>() {
            @Override
            public Boolean call(Object arg) {
                if(classSet.contains(arg.getClass())) return Boolean.TRUE;
                return Boolean.FALSE;
            }
        };
    }

    public static UnaryFunction<Boolean, Object> classTester(final Class<?> ... classes) {
        return new UnaryFunction<Boolean, Object>() {
            @Override
            public Boolean call(Object arg) {
                for(Class<?> clazz : classes) {
                    if(clazz.isInstance(arg)) return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    /**
     * @param session
     * @param resourceManager
     * @param factoryHints
     * @return
     */
    public static Evaluator createResourceEvaluator() {
        Evaluator resourceEvaluator = new EvaluatorImpl();

        resourceEvaluator.addViewpoint(new ResourceViewpointFactory(), 1.0);
        resourceEvaluator.addComparator(new AlphanumericComparatorFactory(ColumnKeys.SINGLE), 2.0);
        resourceEvaluator.addLabeler(new StringRepresentationLabelerFactory(), 1.0);
        resourceEvaluator.addImager(new OldAdapterImagerFactory(), 1.0);

        return resourceEvaluator;
    }

    /**
     * @param session
     * @param resourceManager
     * @param factoryHints
     * @param tester
     * @return
     */
    public static Evaluator createResourceEvaluator(final UnaryFunction<Boolean, Object> tester) {
        Evaluator resourceEvaluator = new EvaluatorImpl();

        resourceEvaluator.addViewpoint(new ResourceViewpointFactoryWithTester(tester), 1.0);
        resourceEvaluator.addComparator(new AlphanumericComparatorFactory(ColumnKeys.SINGLE), 2.0);
        resourceEvaluator.addLabeler(new StringRepresentationLabelerFactory(), 1.0);
        resourceEvaluator.addImager(new OldAdapterImagerFactory(), 1.0);

        return resourceEvaluator;
    }

    /**
     * @param session
     * @param resourceManager
     * @return
     */
    public static Evaluator createNodeEvaluator() {
        Evaluator nodeEvaluator = new EvaluatorImpl();

        nodeEvaluator.addViewpoint(new NodeViewpointFactory(), 1.0);
        nodeEvaluator.addComparator(new AlphanumericComparatorFactory(ColumnKeys.SINGLE), 2.0);
        nodeEvaluator.addLabeler(new NodeLabelerFactory(), 1.0);
        nodeEvaluator.addImager(new NodeImagerFactory(), 1.0);

        return nodeEvaluator;
    }

    /**
     * @param session
     * @param resourceManager
     * @param tester
     * @return
     */
    public static Evaluator createNodeEvaluator(final UnaryFunction<Boolean, Object> tester) {
        Evaluator nodeEvaluator = new EvaluatorImpl();

        nodeEvaluator.addViewpoint(new NodeViewpointFactoryWithTester(tester), 1.0);
        nodeEvaluator.addComparator(new AlphanumericComparatorFactory(ColumnKeys.SINGLE), 2.0);
        nodeEvaluator.addLabeler(new NodeLabelerFactory(), 1.0);
        nodeEvaluator.addImager(new NodeImagerFactory(), 1.0);

        return nodeEvaluator;
    }

    /**
     * @param session
     * @param resourceManager
     * @return
     */
    public static Evaluator createNode2Evaluator() {
        Evaluator nodeEvaluator = new EvaluatorImpl();

        nodeEvaluator.addViewpoint(new Node2ViewpointFactory(), 1.0);
        nodeEvaluator.addComparator(new AlphanumericComparatorFactory(ColumnKeys.SINGLE), 2.0);
        nodeEvaluator.addLabeler(new Node2LabelerFactory(), 1.0);
        nodeEvaluator.addImager(new Node2ImagerFactory(), 1.0);

        return nodeEvaluator;
    }

}

abstract class BaseViewpointFactory implements ViewpointFactory {
    protected abstract class VPB extends LazyViewpoint implements Supplier<Boolean>, IChildrenCallback {
        public VPB(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
            super(updater, context, key);
        }

        @Override
        public String toString() {
            return BaseViewpointFactory.this.toString();
        }

        @Override
        public Object getIdentity() {
            // This is necessary to give graph requests related to this
            // LazyViewpoint a unique-enough identity so that they don't collide
            // unexpectedly with other users of ModelEvaluators.
            // This makes requests created with different concrete classes of
            // BaseViewpointFactory unique.
            return BaseViewpointFactory.this.getClass();
        }

        @Override
        public Boolean get() {
            return Boolean.valueOf(updater.isDisposed());
        }

        @Override
        public void refreshChildren(Collection<?> newChildren) {
            NodeContext[] ncs = toContextsWithInput(newChildren);
            setHasChildren(ncs.length > 0);
            setChildren(updater, ncs);
            updater.scheduleReplace(context, key, this);
        }

        @Override
        public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
            // hasChildren must do the same graph operations as children
            // since they both share the same PrimitiveQueryUpdater.
            return children(graph).length > 0;
        }
    };
}

abstract class BaseViewpointFactoryWithTester extends BaseViewpointFactory {
    protected final UnaryFunction<Boolean, Object> tester;

    BaseViewpointFactoryWithTester(UnaryFunction<Boolean, Object> tester) {
        this.tester = tester;
    }
}

class ResourceViewpointFactory extends BaseViewpointFactory {
    @Override
    public String toString() {
        return "Consists Of";
    }

    class VP extends VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
            super(updater, context, key);
        }

        @Override
        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            return toContextsWithInput( getChildren(graph, (Resource) context.getConstant(BuiltinKeys.INPUT)) );
        }

        protected Collection<?> getChildren(ReadGraph g, Resource r) throws DatabaseException {
        	Layer0 b = Layer0.getInstance(g);
            Collection<Resource> resources = g.getObjects(r, b.ConsistsOf);
            ArrayList<Object> ret = new ArrayList<Object>(resources.size());
            for (Resource res : resources) {
                Object node = null;
//              try {
//                  node = g.adapt2(res, INode2.class));
//              } catch (AdaptionException e) {
                node = g.getPossibleAdapter(res, INode.class);
                if (node != null) {
                    if (node instanceof IDisposable)
                        ((IDisposable) node).setDisposedCallable(this);
//                    if (node instanceof IUpdateable)
//                        ((IUpdateable) node).setChildrenCallback(this);
                    ret.add(node);
//                  }
                }
            }
            return ret;
        }
    };

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
        return new VP(updater, context, key);
    }
}

class ResourceViewpointFactoryWithTester extends BaseViewpointFactoryWithTester {

    ResourceViewpointFactoryWithTester(UnaryFunction<Boolean, Object> tester) {
        super(tester);
    }

    @Override
    public String toString() {
        return "Consists Of";
    }

    class VP extends VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
            super(updater, context, key);
        }

        @Override
        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            return toContextsWithInput( getChildren(graph, (Resource) context.getConstant(BuiltinKeys.INPUT)) );
        }

        protected Collection<?> getChildren(ReadGraph g, Resource r) throws DatabaseException {
        	Layer0 b = Layer0.getInstance(g);
            Collection<Resource> resources = g.getObjects(r, b.ConsistsOf);
            ArrayList<Object> ret = new ArrayList<Object>(resources.size());
            for (Resource res : resources) {
                Object node = null;
//              try {
//                  node = g.adapt2(res, INode2.class));
//              } catch (AdaptionException e) {
                node = g.getPossibleAdapter(res, INode.class);
                if (node != null) {
                    if (tester.call(node)) {
                        if (node instanceof IDisposable)
                            ((IDisposable) node).setDisposedCallable(this);
//                        if (node instanceof IUpdateable)
//                            ((IUpdateable) node).setChildrenCallback(this);
                        ret.add(node);
                    }
                }
//              }
            }
            return ret;
        }
    };

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
        return new VP(updater, context, key);
    }
}

class NodeViewpointFactory extends BaseViewpointFactory {
    @Override
    public String toString() {
        return "Standard";
    }

    class VP extends VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
            super(updater, context, key);
        }

        @Override
        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            INode node = (INode) context.getConstant(BuiltinKeys.INPUT);
            if (node instanceof IUpdateable)
                ((IUpdateable) node).setChildrenCallback(this);

            Collection<?> children = node.getChildren(graph);
            for (Object child : children) {
                if (child instanceof IDisposable)
                    ((IDisposable) child).setDisposedCallable(this);
            }
            return toContextsWithInput(children);
        }
    };

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
        return new VP(updater, context, key);
    }
}

class NodeViewpointFactoryWithTester extends BaseViewpointFactoryWithTester {

    NodeViewpointFactoryWithTester(final UnaryFunction<Boolean, Object> tester) {
        super(tester);
    }

    @Override
    public String toString() {
        return "Standard";
    }

    class VP extends VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key) {
            super(updater, context, key);
        }

        @Override
        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            INode node = (INode) context.getConstant(BuiltinKeys.INPUT);
            if (node instanceof IUpdateable)
                ((IUpdateable) node).setChildrenCallback(this);

            ArrayList<Object> result = new ArrayList<Object>();
            for (Object child : node.getChildren(graph)) {
                if (tester.call(child)) {
                    result.add(child);
                    if (child instanceof IDisposable)
                        ((IDisposable) child).setDisposedCallable(this);
                }
            }
            return toContextsWithInput(result);
        }
    }

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater,NodeContext context, ViewpointKey key) {
        return new VP(updater, context, key);
    }

}

class NodeLabelerFactory implements LabelerFactory {
    @Override
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, LabelerKey key) {
        return new LazyGraphLabeler(updater, context, key) {
            @Override
            public Object getIdentity(LabelerKey key) {
                return NodeLabelerFactory.this.getClass();
            }

            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                return Collections.singletonMap(ColumnKeys.SINGLE,
                        ((INode) context.getConstant(BuiltinKeys.INPUT)).getLabel(graph));
            }

            @Override
            public Modifier getModifier(ModificationContext sourcePart, String key) {
                return ((INode) context.getConstant(BuiltinKeys.INPUT)).getModifier(Simantics.getSession(), key);
            }

            @Override
            public int category(ReadGraph graph) throws DatabaseException {
                return ((INode) context.getConstant(BuiltinKeys.INPUT)).getCategory(graph);
            }

            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(NodeLabelerFactory.class);
            }
        };
    }
}

class NodeImagerFactory implements ImagerFactory {

    @Override
    public Imager create(final PrimitiveQueryUpdater updater, final NodeContext context, final ImagerKey key) {
        final ContainerImager<ImageDescriptor> result = new ContainerImager<ImageDescriptor>();
        result.setImage(MissingImageDescriptor.getInstance());

        DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);

        source.schedule(g -> {
            try {
                ImageDescriptor descriptor = ((INode)context.getConstant(BuiltinKeys.INPUT)).getImage(g);
                result.setImage(descriptor);
                updater.scheduleReplace(context, key, result);
            } catch (DatabaseException e) {
                e.printStackTrace();
            }
        });

        return result;
    }

}

class Node2ViewpointFactory implements ViewpointFactory {

    @Override
    public String toString() {
        return "Standard";
    }

    @Override
    public Viewpoint create(final PrimitiveQueryUpdater updater, final NodeContext context, final ViewpointKey key) {
        class V extends ViewpointStub implements Runnable, Supplier<Boolean> {
            @Override
            public void run() {
                updater.scheduleReplace(context, key, V.this);
            }

            @Override
            public Boolean get() {
                return Boolean.valueOf(updater.isDisposed());
            }

            @Override
            public NodeContext[] getChildren() {
                Collection<?> children = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getChildren(this, context);
                for (Object child : children) {
                    if (child instanceof IDisposable)
                        ((IDisposable) child).setDisposedCallable(this);
                }
                return toContextsWithInput(children);
            }

            @Override
            public Boolean getHasChildren() {
                return ((INode2) context.getConstant(BuiltinKeys.INPUT)).hasChildren(this, context);
            }
        }

        return new V();
    }
}

class Node2LabelerFactory implements LabelerFactory {

    @Override
    public Labeler create(final PrimitiveQueryUpdater updater, final NodeContext context, final LabelerKey key) {

        class L extends LabelerStub implements Runnable {
            @Override
            public Modifier getModifier(ModificationContext sourcePart, String key) {
                return ((INode2)context.getConstant(BuiltinKeys.INPUT)).getModifier(key);
            }
            @Override
            public void run() {
                String label = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getLabel(this, context);
                int category = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getCategory(this, context);
                setContent(new LabelerContent(category, Collections.singletonMap(ColumnKeys.SINGLE, label)));
                updater.scheduleReplace(context, key, this);
            }
        };

        L result = new L();

        String label = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getLabel(result, context);
        int category = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getCategory(result, context);
        result.setContent(new LabelerContent(category, Collections.singletonMap(ColumnKeys.SINGLE, label)));

        return result;
    }

}

class Node2ImagerFactory implements ImagerFactory {

    @Override
    public Imager create(final PrimitiveQueryUpdater updater, final NodeContext context, final ImagerKey key) {
        assert(updater != null);
        assert(context != null);

        final ContainerImager<ImageDescriptor> result = new ContainerImager<ImageDescriptor>();

        Runnable callback = new Runnable() {
            @Override
            public void run() {
                ImageDescriptor desc = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getImage(this, context);
                result.setImage(desc);
                updater.scheduleReplace(context, key, result);
            }
        };

        ImageDescriptor desc = ((INode2) context.getConstant(BuiltinKeys.INPUT)).getImage(callback, context);
        result.setImage(desc);
        return result;

    }

}
