/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DiagramToolViewPart extends ViewPart {

    private Composite parent;

    private final List<DiagramTools> tools = new ArrayList<DiagramTools>();
    private final Map<DiagramTools,Composite> toolComposites = new HashMap<DiagramTools, Composite>();

    private ISelectionListener listener;

    protected LocalResourceManager resourceManager;

    protected FormToolkit formToolkit;

    protected ScrolledForm mainForm;

    public DiagramToolViewPart() {

    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout(new FillLayout());
        //this.parent.setLayout(new GridLayout(1, true));

        listener = new ISelectionListener() {

            @Override
            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                // FIXME: selection logic must be improved.
                // We want to disable tools, if selection does not come from DiagramEditor, or its outline
                if (!(part instanceof DiagramEditor)) {
                    return;
                }
                for (DiagramTools t : tools) {
                    t.setSelection(selection);
                }

            }
        };
        getSite().getPage().addPostSelectionListener(listener);

        resourceManager = new LocalResourceManager(JFaceResources.getResources(parent.getDisplay()), parent);

        formToolkit = new FormToolkit(parent.getDisplay());
        formToolkit.adapt(parent);
        mainForm = formToolkit.createScrolledForm(parent);
        mainForm.getBody().setLayout(GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 5).spacing(1,1).create());
        formToolkit.decorateFormHeading(mainForm.getForm());
        mainForm.setText("Tools");

        // Default set of tools.
        openTool(new AlignTools());
    }

    @Override
    public void setFocus() {
        parent.setFocus();

    }

    public void openTool(final DiagramTools tool) {
        // Allow opening tool only once.
        for (DiagramTools t : tools) {
            if (t.getClass().equals(tool.getClass()))
                return;
        }

        Section group = formToolkit.createSection(mainForm.getBody(), Section.TITLE_BAR | Section.TWISTIE);
        group.setText(tool.getName());
        GridData data = new GridData(SWT.FILL, SWT.TOP, true, false);
        group.setLayoutData(data);
        Composite composite = formToolkit.createComposite(group);

        tool.createContols(composite, formToolkit, resourceManager);
        group.setClient(composite);

        ToolBar toolBar = new ToolBar(group, SWT.NO_FOCUS | SWT.FLAT);
//        ToolItem closeButton = new ToolItem(toolBar, SWT.PUSH);
//        closeButton.setToolTipText("Close " + tool.getName() + " Tools");
//        closeButton.setImage(resourceManager.createImage(ImageDescriptor.createFromURL(Activator.getDefault().getBundle().getResource("icons/silk/cross.png"))));
        group.setTextClient(toolBar);

        group.setExpanded(true);

//        closeButton.addSelectionListener(new SelectionAdapter() {
//            @Override
//            public void widgetSelected(SelectionEvent e) {
//                closeTool(tool);
//            }
//        });

        tools.add(tool);
        toolComposites.put(tool, group);
        parent.layout(true, true);

        tool.setSelection(getSite().getPage().getSelection());

    }

    private void closeTool(DiagramTools tool) {
        tool.dispose();
        tools.remove(tool);
        toolComposites.remove(tool).dispose();
    }

    @Override
    public void dispose() {
        List<DiagramTools> tls = new ArrayList<DiagramTools>();
        tls.addAll(tools);
        for (DiagramTools t : tls) {
            closeTool(t);
        }
        getSite().getPage().removePostSelectionListener(listener);
        listener = null;
        formToolkit.dispose();
        super.dispose();
    }

    public static void open(DiagramTools tool) throws PartInitException {
        DiagramToolViewPart wp = (DiagramToolViewPart)WorkbenchUtils.showView("org.simantics.modeling.ui.diagramtool");
        wp.openTool(tool);
    }

}
