/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseDoubleClickedEvent;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * StructuralBrowsingHandler supports visual browsing into subcomponents through
 * mouse events.
 * 
 * @author Tuukka Lehtonen
 */
public class HeadlessStructuralBrowsingHandler extends AbstractCanvasParticipant {

    @Dependency
    Selection          selection;
    ISessionContext    sessionContext;
    ResourceArray      parentStructuralPath;
    IDiagramUpdateSupport diagramProvider;
    
    public static interface IDiagramUpdateSupport {
    	public void updateDiagram(ResourceArray structuralPath);
    }
    
    public HeadlessStructuralBrowsingHandler(IDiagramUpdateSupport diagramProvider, ISessionContext sessionContext, ResourceArray parentStructuralPath) {
        assert diagramProvider != null;

        this.diagramProvider = diagramProvider;
        this.sessionContext = sessionContext;
        this.parentStructuralPath = parentStructuralPath;
    }

    @EventHandler(priority = 0)
    public boolean handleDoubleClick(MouseDoubleClickedEvent me) {
        if (sessionContext == null)
            return false;

        Set<IElement> sel = selection.getSelection(0);

        if (sel.size() == 1) {
            IElement e = sel.iterator().next();
            Object data = e.getHint(ElementHints.KEY_OBJECT);
            if (data instanceof Resource) {
                final Resource element = (Resource) data;
                sessionContext.getSession().asyncRequest(new ReadRequest() {
                    @Override
                    public void run(ReadGraph graph) throws DatabaseException {
                        ModelingResources mr = ModelingResources.getInstance(graph);
                        DiagramResource dr = DiagramResource.getInstance(graph);
                        StructuralResource2 sr = StructuralResource2.getInstance(graph);

                        if (graph.isInstanceOf(element, dr.Flag)) {
                            /* FIXME: implement headless version
                            ContextMap parameters = new ContextMap();
                            parameters.put(ModelingOperationConstants.WORKBENCH_WINDOW, site.getWorkbenchWindow());
                            parameters.put(ModelingOperationConstants.WORKBENCH_PART, site.getPart());
                            parameters.put(IOperation.SUBJECT, element);
                            new NavigateToTarget().exec(graph.getSession(), parameters);
                            */
                            return;
                        }

                        final Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
                        if (component == null)
                            return;

                        Resource type = graph.getSingleType(component, sr.Component);
                        if (type == null)
                            return;

                        Resource definedBy = graph.getPossibleObject(type, sr.IsDefinedBy);
                        if (definedBy == null)
                            return;

                        final Resource diagram = graph.getPossibleObject(definedBy, mr.CompositeToDiagram);
                        if (diagram == null)
                            return;

                        diagramProvider.updateDiagram(parentStructuralPath.prepended(diagram, component));
                    }
                });
            }

            return true;
        }

        return false;
    }

}
