package org.simantics.modeling.ui.diagram.monitor;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class RealizedFormatterAdapter extends SimpleContextualAdapter<Formatter, RelationContext> {

	@Override
	public Formatter adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource formatter = context.getStatement().getObject();

		String definition = graph.getRelatedValue(formatter, DIA.RealizedFormatter_HasDefinition, Bindings.STRING);
		final String label = graph.getPossibleRelatedAdapter(formatter, L0.HasLabel, String.class);
		final DecimalFormat format = new DecimalFormat(definition, DecimalFormatSymbols.getInstance(Locale.US));
		final String toString = label + " (" + definition + ")"; //$NON-NLS-1$ //$NON-NLS-2$

		return new Formatter() {

			private String formatNumber(Number v) {
				double dv = v.doubleValue();
				if (Double.isInfinite(dv)) {
					return (dv == Double.POSITIVE_INFINITY) ? "\u221E" : "-\u221E"; //$NON-NLS-1$ //$NON-NLS-2$
				} else if (Double.isNaN(dv)) {
					return "NaN"; //$NON-NLS-1$
				} else {
					return format.format(v);
				}
			}

			@Override
			public String format(Object object) {
				if (object instanceof Number) {
					Number num = (Number) object;
					return formatNumber(num);
				}
				else if(object instanceof String) {
					try {
						Double d = Double.parseDouble((String)object);
						return formatNumber(d);
					} catch (NumberFormatException e) {
						return (String)object;
					}
				} else {
					return object != null ? object.toString() : ""; //$NON-NLS-1$
				}
			}

			@Override
			public String toString() {
				return toString;
			}

		};

	}

}
