package org.simantics.modeling.ui.diagram.monitor;

import java.util.ArrayList;
import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.property.OrderedResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.operation.Layer0X;
import org.simantics.ui.fonts.FontDescriptor;

public class ObtainedFontAdapter extends SimpleContextualAdapter<FontDescriptor, RelationContext> {

	@Override
	public FontDescriptor adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
		
	    Layer0X L0X = Layer0X.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
		for(Statement stm : graph.getStatements(context.getSubject(), L0X.ObtainsProperty)) {
			Integer position = graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, Bindings.INTEGER);
			order.add(new OrderedResource(position, stm.getObject()));
		}
		if (order.size() > 1)
			Collections.sort(order);
		for(OrderedResource or : order) {
			FontDescriptor result = graph.getPossibleRelatedAdapter(or.r, DIA.HasFont, FontDescriptor.class);
			if(result != null) return result;
		}
		
		throw new AdaptionException("No obtained font available");
		
	}

}
