/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.common.format.Formatter;
import org.simantics.db.Resource;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 */
public class MonitorVariable extends Tuple {

    public MonitorVariable(Resource monitorComponent, Formatter formatter, String expression, Variable variable, RVI rvi, Boolean external) {
        super(monitorComponent, formatter, expression, variable, rvi, external);
    }
    public Resource getMonitorComponent() {
        return (Resource) getField(0);
    }
    public Variable getVariable() {
        return (Variable) getField(3);
    }
    public RVI getRVI() {
        return (RVI) getField(4);
    }
    public Formatter getFormat() {
        return (Formatter)getField(1);
    }
    public String getExpression() {
        return (String)getField(2);
    }
    public Boolean isExternal() {
        return (Boolean)getField(5);
    }

}