/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram;

import java.awt.geom.AffineTransform;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.MonitorSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.swing.SymbolMonitorClass;


/**
 * TODO: recognize experiment disposal and reset monitor contents at that point
 * FIXME: SymbolMonitorClass is not properly implemented equals/hashCode-wise
 */
public class SymbolMonitorClassFactory extends SyncElementFactory {

	public static ElementClass createMonitorClass(Resource elementClass) {
        // set "default scale" to no scaling, 1.0, 1.0
        return SymbolMonitorClass.create(null, null, null, 1.0, 1.0, new StaticObjectAdapter(elementClass));
    }

    @Override
    public void load(ReadGraph g, final ICanvasContext canvas, final IDiagram diagram, final Resource element, final IElement e) throws DatabaseException {
    	
    	Layer0 b = Layer0.getInstance(g);

        // Must be done here to allow for the relationship manager to work properly.
        e.setHint(ElementHints.KEY_OBJECT, element);
        
        String name = g.getPossibleRelatedValue(element, b.HasName);
        if(name != null) e.setHint(ElementHints.KEY_SG_NAME, name);

        AffineTransform at = DiagramGraphUtil.getAffineTransform(g, element);
        ElementUtils.setTransform(e, at);

        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, MonitorSynchronizer.INSTANCE);
        
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType,
            AsyncProcedure<ElementClass> procedure) {
    	
        procedure.execute(graph, createMonitorClass(elementType));
        
    }

}