package org.simantics.modeling.ui.componentTypeEditor;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.modeling.utils.HeadlessComponentTypePropertiesResultRequest;

public class ComponentTypePropertiesResultRequest extends HeadlessComponentTypePropertiesResultRequest {
    
    private final Collection<ComponentTypeViewerSection> sections;

    /**
     * @param componentTypeViewer
     */
    public ComponentTypePropertiesResultRequest(Resource componentType, Collection<ComponentTypeViewerSection> sections) {
        super(componentType);
        this.sections = sections;
    }
    
    @Override
    protected void readSectionSpecificData(ReadGraph graph, ComponentTypeViewerPropertyInfo info) throws DatabaseException {
        
        Object sectionSpecificData = null;
        double priority = Double.NEGATIVE_INFINITY;
        if(sections != null) {
            for(ComponentTypeViewerSection section : sections) {
                Object temp = section.getSectionSpecificData(graph, info);
                if(temp != null) {
                    double sectionPriority = section.getDataPriority();
                    if(sectionPriority > priority) {
                        sectionSpecificData = temp;
                        priority = sectionPriority;
                    }
                }
            }
        }
        
        info.sectionSpecificData = sectionSpecificData;

    }

}