/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

/**
 * @author Tuukka Lehtonen
 */
public class CurrentTemplateFactory extends ReadFactoryImpl<Resource, String> {

	@Override
	public String perform(ReadGraph graph, Resource monitor) throws DatabaseException {
		
		Layer0 L0 = Layer0.getInstance(graph);
		Layer0X L0X = Layer0X.getInstance(graph);
		Resource template = graph.getPossibleObject(monitor, L0X.ObtainsProperty);
		if (template != null) {
			return graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
		} else {
			return null;
		}
		
	}
	
}
